// This is a simple ToDo- application
import QtQuick 1.1
import Sailfish.Silica 1.0

ApplicationWindow {
    property Item contextMenu

    initialPage: Page {

        // RemorsePopup is defined here, but only shown when user selects clear all from the pulleymenu
        RemorsePopup {
            id: remorse
        }

        SilicaListView {
            id: listView
            anchors.fill: parent

            // SailfishOS style pulley menu
            PullDownMenu {
                MenuItem {
                    text: "Clear all"

                    // This open RemorsePopup and if user does not cancel, then executs the code defined
                    // it the inline function, which clears todo list content
                    onClicked: {
                        remorse.execute("Clearing all items", function() { listView.model.clear() } )
                    }
                }
            }

            header: PageHeader { title: "TODO List" }

            // model stores the content of the list
            // initially we are having one ToDo item "Buy food"
            model: ListModel { ListElement { topic: "Buy food" } }

            // delegate defines how item in list is shown
            delegate: Item {
                id: listItem

                property bool menuOpen: contextMenu != null && contextMenu.parent === listItem
                width: ListView.view.width

                // if contextmenu is open we reserve space for it
                height: menuOpen ? contextMenu.height + contentItem.height : contentItem.height

                // How single todo item is shown in the list is defined here
                BackgroundItem {

                    id: contentItem
                    Label {
                        anchors.verticalCenter: parent.verticalCenter
                        x: theme.paddingLarge
                        text: topic
                    }

                    // If user presses long over the item
                    // then the app opens contextmenu
                    onPressAndHold: {
                        if (!contextMenu)
                            contextMenu = contextMenuComponent.createObject(listView)
                        contextMenu.show(listItem)
                    }
                }

                // contextmenu with just one menuitem - "delete"
                Component {
                    id: contextMenuComponent

                    ContextMenu {
                        MenuItem {
                            text: "Delete"
                            onClicked: listView.model.remove(index)
                        }
                    }
                }
            }

            // TextField to the end of the list for entering new ToDo items
            footer: TextField {
                width: listView.width
                placeholderText: "Enter new ToDo item"

                // return accepts the input and adds the text to the list
                Keys.onReturnPressed: {
                    if (text != "") {
                        listView.model.append( {"topic":text} )
                        text = ""
                    }
                }
            }
        }
    }
}
